<?php
/**
 * Plugin Name: Fix Candidate Dashboard AJAX Nonce
 * Description: Injects missing security nonce for candidate profile AJAX calls
 * Author: JobCareer Child Theme
 * Version: 1.0
 */

// This mu-plugin loads BEFORE all other plugins, ensuring our fix runs first

// Inject nonce as early as possible - right when WordPress finishes setting up
add_action('plugins_loaded', 'fix_candidate_ajax_nonce_early', -9999);

function fix_candidate_ajax_nonce_early() {
    // Only for AJAX requests
    if (!defined('DOING_AJAX') || !DOING_AJAX) {
        return;
    }
    
    // Check if this is the candidate profile AJAX action
    if (isset($_POST['action']) && $_POST['action'] === 'cs_ajax_candidate_profile') {
        // Hook very early into WordPress init to inject the nonce
        // Priority -9999 ensures we run before anything else
        add_action('init', 'fix_candidate_ajax_nonce_inject', -9999);
    }
}

function fix_candidate_ajax_nonce_inject() {
    // Double-check we're still dealing with the right AJAX action
    if (isset($_POST['action']) && $_POST['action'] === 'cs_ajax_candidate_profile') {
        // Inject the nonce that the plugin expects
        // Create it now that WordPress is fully loaded
        $_POST['security'] = wp_create_nonce('cs_candidate_nonce');
        $_REQUEST['security'] = $_POST['security'];
    }
}
